//*************+***************+***************+***************+***************+
//
//	SEKONIC
//	Device control Parameter header
//
//	FileName	: SkDvSr11000Prm.h
//	CPU			: x86
//	Compiler	: Microsoft Visual C++ 6.0 or later
//
//*************+***************+***************+***************+***************+
//	2013.04.24	add define for GetPanelUserSwitch
//					SKDV_PANEL_SW_UP etc
//	2012.08.13	for SR-11000
//*************+***************+***************+***************+***************+
#ifndef	INCLUDE_SKDVSR11000PRM_HEADER			// Multi include of a header is prevented.
#define	INCLUDE_SKDVSR11000PRM_HEADER

#pragma once

#include "SkDvSrSeriesPrm.h"


//*************+***************+***************+***************+***************+
//	define / typedef
//*************+***************+***************+***************+***************+
//-----+-------+-------+-------+-------+-------+-------+-------+

#define	SKDV_LAYOUT_ID_PTN_LEN					8				// ID Pattern data length [byte]

//-----+-------+-------+-------+-------+-------+-------+-------+
// Check the number of bar code
// SK_LAYOUT_ID_PRM - iBarcodeCount
#define	SKDV_LAYOUT_BC_COUNT_NOCHECK			99				// Do not check the number of bar code

//-----+-------+-------+-------+-------+-------+-------+-------+
// Behavior at the time of occurrence of NG
// SK_LAYOUT_MANAGE_CONF - dwNgAction
// SK_WINDOW_AREA_CONF - dwNgAction
#define	SKDV_ACTION_SELECT						0x00000001		// Waste paper to select stacker
#define	SKDV_ACTION_STOP						0x00000002		// Stop reading
#define	SKDV_ACTION_NOPRINT						0x00000004		// Printer does not print


//-----+-------+-------+-------+-------+-------+-------+-------+
// Operating limits for continuous reading
//	SkDv_ReqSetLayoutManageTerminate - piLimit
#define	SKDV_CONT_FEED_LIMIT_NONE				0				// No limit
#define	SKDV_CONT_FEED_LIMIT_PAUSE				1				// Pause before reading(Regardless of whether or printed)
#define	SKDV_CONT_FEED_LIMIT_PAUSE_PRINT		2				// Pause before reading(If you want to print)
																	// !! Temporarily stopped by a piece of continuous reading 
																	//    If you have a large number of marks and the number of windows in the process window

//-----+-------+-------+-------+-------+-------+-------+-------+
// Reading direction window
// SK_WINDOW_PRM - iDirection
#define SKDV_WIN_DIR_TL_DOWN					0				// Down from top left
#define SKDV_WIN_DIR_TR_DOWN					1				// Down from top right
#define SKDV_WIN_DIR_BL_UP						2				// Up from bottom left
#define SKDV_WIN_DIR_BR_UP						3				// Up from bottom right
#define SKDV_WIN_DIR_TL_RIGHT					4				// Right from top left
#define SKDV_WIN_DIR_TR_LEFT					5				// Left from top right
#define SKDV_WIN_DIR_BL_RIGHT					6				// Right from bottom left
#define SKDV_WIN_DIR_BR_LEFT					7				// Left from bottom right

//-----+-------+-------+-------+-------+-------+-------+-------+
// Partitioning
// SK_WINDOW_PRM - iPartition
#define SKDV_WIN_PART_OFF						0				// None
#define SKDV_WIN_PART_ON_START0					1				// Split some Pateishon(0 start)
#define SKDV_WIN_PART_ON_START1					2				// Split some Pateishon(1 start)
																	// We can specify whether you want to start 
																	// from the beginning if 0 arithmetic processing, 
																	// such as range checking is performed, to start from 1.

//-----+-------+-------+-------+-------+-------+-------+-------+
// Check mark option number
// SK_WINDOW_CHECK - iOption
#define SKDV_WIN_CHK_NOMARK_ERR_ENABLE			0				// No mark as an error
#define SKDV_WIN_CHK_NOMARK_ERR_DISABLE			1				// No mark is not an error

//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_LAYOUT_OPTION - iType - (Common)
#define	SKDV_LAYOUT_OPT_NONE					0x00			// Invalid

// SK_LAYOUT_OPTION - iType - (Layout option)
#define	SKDV_LAYOUT_OPT_ORDER_ID				0x01			// Check order ID

// SK_LAYOUT_OPTION - iType - (Layout id option)
//(Reserved)

// SK_LAYOUT_OPTION - iType - (Window option)
#define	SKDV_LAYOUT_OPT_MASK					0x01			// Mask setting
#define	SKDV_LAYOUT_OPT_FIXED_COMP				0x02			// Compare fixed mark
#define	SKDV_LAYOUT_OPT_CHECK_DIGIT				0x03			// Check Digit
#define	SKDV_LAYOUT_OPT_ASCENDING_ORDER			0x04			// Range check(Ascending order)
#define	SKDV_LAYOUT_OPT_DESCENDING_ORDER		0x05			// Range check(Descending order)
#define	SKDV_LAYOUT_OPT_RANGE_CHECK				0x06			// Range check(No order)
#define	SKDV_LAYOUT_OPT_MASK_PART				0x07			// Compare fixed mark(Pateishon common)

// SK_LAYOUT_OPTION - ucData
#define	SKDV_LAYOUT_OPT_LEN						16				// Option data length [byte]


//-----+-------+-------+-------+-------+-------+-------+-------+
// Cont Feed Request Data
//	SkDv_ReqContFeedSheet - dwReqData
#define	SKDV_CONT_FEED_REQ_NORMAL				0x0000			// Continuous reading
#define	SKDV_CONT_FEED_REQ_SHEET_12INCHES_OVER	0x6000			// Specify to 12 inches over the sheet size
#define	SKDV_CONT_FEED_REQ_SHEET_12INCHES_BELOW	0x2000			// Specify to 12 inches below the sheet size


//-----+-------+-------+-------+-------+-------+-------+-------+
// Reading the results of ID
//	SK_DV_WINDOW_RESULT.iId
//	SK_SHEET_RESULT.iId
#define	SKDV_RESULT_ID_MIN						0				// The minimum value of the layout ID
#define	SKDV_RESULT_ID_MAX						15				// The maximum value of the layout ID
#define	SKDV_RESULT_ID_NUM						16				// Number of Layout ID

#define	SKDV_RESULT_ID_NONE						0				// ID number of "not used ID"
#define	SKDV_RESULT_ID_UNKNOWN					99				// ID mismatch

//-----+-------+-------+-------+-------+-------+-------+-------+
// Maximum number of window
#define SKDV_WINDOW_NORMAL_MAX					80				// The maximum number of windows and the ID of one standard
#define SKDV_WINDOW_TOTAL_MAX					255				// The maximum number of windows and the ID of one

//-----+-------+-------+-------+-------+-------+-------+-------+
// 
//	SK_SHEET_RESULT.iPrinted
#define	SKDV_RESULT_PRN_NONE					0				// Without printing/Unprinted
#define	SKDV_RESULT_PRN_PRINTED					1				// Printed

//-----+-------+-------+-------+-------+-------+-------+-------+
// 
//	SK_SHEET_RESULT.iStackedId
#define	SKDV_RESULT_STK_NONE					0				// Waste not paper
#define	SKDV_RESULT_STK_MAIN					1				// Main paper ejection
#define	SKDV_RESULT_STK_SELECTION				2				// Select paper ejection
#define	SKDV_RESULT_STK_CNT						3				// Type the number of

//-----+-------+-------+-------+-------+-------+-------+-------+
// End result notification data transport
//	SK_SHEET_RESULT.dwResult
//	!!Combination
#define	SKDV_RESULT_STS_OK						0x00000000		// Normal
#define	SKDV_RESULT_STS_ERROR_EJECT				0x00000004		// Waste paper error
#define	SKDV_RESULT_STS_ERROR_STOP				0x00000002		// Stop error
#define	SKDV_RESULT_STS_WINDOW_NG				0x00000001		// NG judgment window
#define	SKDV_RESULT_STS_ID_NG					0x00000008		// NG judgment ID


//-----+-------+-------+-------+-------+-------+-------+-------+
// ID recognition results
//	SK_SHEET_RESULT.iIdResult
#define	SKDV_RESULT_ID_OK						0				// Normal
#define	SKDV_RESULT_ID_TM_CNT_DIFF_F			1				// Number mismatch frontside timing marks
#define	SKDV_RESULT_ID_TM_CNT_DIFF_B			2				// Number mismatch backside timing marks
#define	SKDV_RESULT_ID_TM_CNT_DIFF_FB			3				// Number mismatch bothside timing marks
#define	SKDV_RESULT_ID_ID_NONE					4				// All layout ID inconsistency
#define	SKDV_RESULT_ID_BC_CNT_DIFF				5				// Number of bar code data mismatch
#define	SKDV_RESULT_ID_ID_ORDER_NG				6				// NG layout order ID

//-----+-------+-------+-------+-------+-------+-------+-------+
// Recognition results window - Reason for NG
//	SK_SHEET_RESULT.NgWindow.iReason
#define	SKDV_RESULT_REASON_OK					0				// Normal
#define	SKDV_RESULT_REASON_MARK_COUNT_LOWER		1				// A small number of marks
#define	SKDV_RESULT_REASON_MARK_COUNT_UPPER		2				// A large number of marks
#define	SKDV_RESULT_REASON_MARK_DISAGREE		3				// Fixed data mismatch
#define	SKDV_RESULT_REASON_CHECK_DIGIT_NG		4				// NG Check Digit
#define	SKDV_RESULT_REASON_ASCENDING_ORDER_NG	5				// NG Range check(Ascending order)
#define	SKDV_RESULT_REASON_DESCENDING_ORDER_NG	6				// NG Range check(Descending order)
#define	SKDV_RESULT_REASON_RANGE_CHECK_NG		7				// NG Range check(No order)


//-----+-------+-------+-------+-------+-------+-------+-------+
// Notice of termination data
//	SK_SHEET_RESULT.iFinish
#define	SKDV_RESULT_FINISH_CONT					0				// Continuity
#define	SKDV_RESULT_FINISH_DONE					1				// End

//-----+-------+-------+-------+-------+-------+-------+-------+
// As a result of continuous transfer
//	SK_CONT_FEED_RESULT.iResult
#define	SKDV_CFR_NORMAL							0				// Normal
#define	SKDV_CFR_ERROR							1				// Abnormal termination
#define	SKDV_CFR_WINDOW_NG						2				// Termination decision window
#define	SKDV_CFR_CANCEL							3				// Termination due to cancellation


//-----+-------+-------+-------+-------+-------+-------+-------+
// GetPanelUserSwitch
#define	SKDV_PANEL_SW_UP						0x00000001		// [UP]key
#define	SKDV_PANEL_SW_DOWN						0x00000002		// [DOWN]key
#define	SKDV_PANEL_SW_MENU						0x00000004		// [MENU]key
#define	SKDV_PANEL_SW_EXIT						0x00000008		// [EXIT]key
#define	SKDV_PANEL_SW_ENTER						0x00000010		// [ENTER]key


//*************+***************+***************+***************+***************+
// struct - Layout
//*************+***************+***************+***************+***************+
//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout Id parameter
typedef struct	tag_SK_LAYOUT_ID_PRM
{
	UCHAR	ucIdData[SKDV_LAYOUT_ID_PTN_LEN];	// ID Pattern data

	int		iTmCount[SKDV_FACE_NUM];			// Number of timing marks
	int		iBarcodeCount;						// Number of Bar code
}SK_LAYOUT_ID_PRM;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Window parameter
typedef struct	tag_SK_WINDOW_PRM
{
	int		iFace;								// Face
	struct
	{											// Column
		int		iStart;								// Start position
		int		iNumber;							// Number
		int		iStep;								// Step(1~)
	}Col;
	struct
	{											// Row
		int		iStart;								// Start position
		int		iNumber;							// Number
		int		iStep;								// Step(1~)
	}Row;
	int		iDirection;							// Direction
	int		iPartition;							// Partitioning
	struct
	{											// Concentration
		int		iSensitivity;						// Sensitivity
		int		iDifference;						// Difference
	}Level;
}SK_WINDOW_PRM;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Window check setting
typedef struct	tag_SK_WINDOW_CHECK
{
	int		iOption;							// Option is specified
													// An error if I do not permit the number of marks 0,
													// even if it is set to Nomaku as errors.
	struct
	{											// Number of marks
		int		iMin;								// The minimum number of marks
		int		iMax;								// The maximum number of marks
	}MarkCount;
}SK_WINDOW_CHECK;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout option
typedef struct	tag_SK_LAYOUT_OPTION
{
	int		iType;								// Optional feature
	union
	{
		UCHAR	ucData[SKDV_LAYOUT_OPT_LEN];		// Parameters for optional features
		struct
		{											// Range check
			DWORD		dwMin;							// Minimum
			DWORD		dwMax;							// Maximum
		}Num;
	};
}SK_LAYOUT_OPTION;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout manage configration
typedef struct	tag_SK_LAYOUT_MANAGE_CONF
{
	BOOL				blEnableId;				// Switching layout ID
	SK_WINDOW_PRM		IdWindowPrm;			// ID window area
	DWORD				dwNgAction;				// Operation at the time of judgment NG
	SK_LAYOUT_OPTION	LayoutOpt;				// Option is specified
}SK_LAYOUT_MANAGE_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout ID configration
typedef struct	tag_SK_LAYOUT_ID_CONF
{
	SK_LAYOUT_ID_PRM	LauoutIdPrm;			// Setting ID
	int					iReject;				// Forced reject
	SK_LAYOUT_OPTION	LayoutOpt;				// Option is specified
}SK_LAYOUT_ID_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Layout Window area configration
typedef struct	tag_SK_WINDOW_AREA_CONF
{
	SK_WINDOW_PRM		WindowPrm;				// Window area
	SK_WINDOW_CHECK		WindowCheck;			// Check window
	DWORD				dwNgAction;				// Operation at the time of judgment NG
	SK_LAYOUT_OPTION	LayoutOpt;				// Option is specified
}SK_WINDOW_AREA_CONF;



//*************+***************+***************+***************+***************+
// struct - for Cont Feed(SR-11000)
//*************+***************+***************+***************+***************+
//-----+-------+-------+-------+-------+-------+-------+-------+
// Option of Continuous feed printing
typedef struct	tag_SK_CONT_FEED_PRN_OPT
{
	int		iDigits;							// Specified number of digits serial number
	int		iStartNumber;						// Initial sequence number value
}SK_CONT_FEED_PRN_OPT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Window data reault
typedef struct tag_SK_DV_WINDOW_RESULT
{
	int		iResult;							// Read results
	int		iId;								// Id number
	int		iCount;								// Number of windows
}SK_DV_WINDOW_RESULT, *PSK_DV_WINDOW_RESULT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Barcode data reault
typedef struct tag_SK_DV_BARCODE_RESULT
{
	int		iResult;							// Read results
	int		iCount;								// Number of Bar code
}SK_DV_BARCODE_RESULT, *PSK_DV_BARCODE_RESULT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Sheet Result
typedef struct	tag_SK_SHEET_RESULT
{
	SkDvStatus	DvStatus;						// Status when read

	int			iSheetCount;					// Count form
	int			iTmCount[SKDV_FACE_NUM];		// Number of timing marks
	int			iBarcodeCount;					// Number of Bar code
	int			iId;							// ID number
	int			iPrinted;						// Printing results
	int			iStackedId;						// Dest
	DWORD		dwResult;						// Result notification
	int			iFinish;						// Notice of termination
	int			iIdResult;						// ID recognition results
	struct
	{											// NG detail window
		int			iCount;							// The total number of NG window

		int			iIndex;							// NG first window number(0~)
		int			iPartIndex;						// NG Pateishon first number(0~)
		int			iReason;						// NG first reason
	}NgWindow;
}SK_SHEET_RESULT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Feed cont Result
typedef struct	tag_SK_CONT_FEED_RESULT
{
	SkDvStatus	DvStatus;						// The final status of the continuous reading

	int			iResult;						// Continuous data processing completion notification
	struct
	{											// (Internal data)
		int			iRead;							// (Internal data)
		int			iPrint;							// (Internal data)
		int			iEject;							// (Internal data)
	}Remain;
}SK_CONT_FEED_RESULT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Sheet count for Cont feed
typedef struct	tag_SK_CONT_FEED_COUNT
{
	int			iFeed;							// Number of paper feed implementation
	int			iNormal;						// Number of normal read
	int			iPrint;							// Number of print reading
	int			iEject[SKDV_RESULT_STK_CNT];	// Number of waste paper
													// 0:Waste not paper
													// 1:Main Stacker
													// 2:Select Stacker
	int			iUntreated;						// Number of untreated waste paper
}SK_CONT_FEED_COUNT;



#endif
